
//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples, 
//we welcome you to contact us at SampleCode@melissadata.com also please visit our 
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace PhoneObjectCS
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>



	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox ZipCode;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label13;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.Label label17;
		private System.Windows.Forms.Label label18;
		private System.Windows.Forms.Label label19;
		private System.Windows.Forms.Label label20;
		private System.Windows.Forms.Label label21;
		private System.Windows.Forms.Label label22;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Label label25;
		private System.Windows.Forms.Label label26;
		private System.Windows.Forms.Label label27;
		private System.Windows.Forms.Label label28;
		private System.Windows.Forms.Button button5;
		private System.Windows.Forms.Button button6;
		private System.Windows.Forms.TextBox PhoneNumber;
		private System.Windows.Forms.Label AreaCode;
		private System.Windows.Forms.Label Latitude;
		private System.Windows.Forms.Label City;
		private System.Windows.Forms.Label Prefix;
		private System.Windows.Forms.Label CountryCode;
		private System.Windows.Forms.Label CountyFips;
		private System.Windows.Forms.Label Distance;
		private System.Windows.Forms.Label MSA;
		private System.Windows.Forms.Label TimeZone;
		private System.Windows.Forms.Label TimeZoneCode;
		private System.Windows.Forms.Label PMSA;
		private System.Windows.Forms.Label Extension;
		private System.Windows.Forms.Label CountyName;
		private System.Windows.Forms.Label Suffix;
		private System.Windows.Forms.Label State;
		private System.Windows.Forms.Label Longitude;
		private System.Windows.Forms.Label NewAreaCode;
		private System.Windows.Forms.TextBox Latitude1;
		private System.Windows.Forms.TextBox Bearing;
		private System.Windows.Forms.TextBox Longitude1;
		private System.Windows.Forms.TextBox Latitude2;
		private System.Windows.Forms.TextBox Longitude2;
		private System.Windows.Forms.TextBox CompDistance;
		private System.Windows.Forms.Label BuildNumber;
		private System.Windows.Forms.Label DatabaseDate;
		private System.Windows.Forms.Label InitErrorString;
		private System.Windows.Forms.Label Results;
		private System.Windows.Forms.Label label30;
		private System.Windows.Forms.Label label23;
		private System.Windows.Forms.Label label24;
		private System.Windows.Forms.Label label29;
		private System.Windows.Forms.Label Validation;
		private System.Windows.Forms.Label ExchangeType;
		private System.Windows.Forms.Label PhoneType;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.Results = new System.Windows.Forms.Label();
			this.label30 = new System.Windows.Forms.Label();
			this.NewAreaCode = new System.Windows.Forms.Label();
			this.Longitude = new System.Windows.Forms.Label();
			this.State = new System.Windows.Forms.Label();
			this.Suffix = new System.Windows.Forms.Label();
			this.CountyName = new System.Windows.Forms.Label();
			this.Extension = new System.Windows.Forms.Label();
			this.PMSA = new System.Windows.Forms.Label();
			this.TimeZoneCode = new System.Windows.Forms.Label();
			this.TimeZone = new System.Windows.Forms.Label();
			this.MSA = new System.Windows.Forms.Label();
			this.Distance = new System.Windows.Forms.Label();
			this.CountyFips = new System.Windows.Forms.Label();
			this.CountryCode = new System.Windows.Forms.Label();
			this.Prefix = new System.Windows.Forms.Label();
			this.City = new System.Windows.Forms.Label();
			this.Latitude = new System.Windows.Forms.Label();
			this.AreaCode = new System.Windows.Forms.Label();
			this.PhoneNumber = new System.Windows.Forms.TextBox();
			this.button2 = new System.Windows.Forms.Button();
			this.button1 = new System.Windows.Forms.Button();
			this.label22 = new System.Windows.Forms.Label();
			this.label21 = new System.Windows.Forms.Label();
			this.label20 = new System.Windows.Forms.Label();
			this.label19 = new System.Windows.Forms.Label();
			this.label18 = new System.Windows.Forms.Label();
			this.label17 = new System.Windows.Forms.Label();
			this.label16 = new System.Windows.Forms.Label();
			this.label15 = new System.Windows.Forms.Label();
			this.label13 = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.ZipCode = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label14 = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.CompDistance = new System.Windows.Forms.TextBox();
			this.Longitude2 = new System.Windows.Forms.TextBox();
			this.Latitude2 = new System.Windows.Forms.TextBox();
			this.Longitude1 = new System.Windows.Forms.TextBox();
			this.Bearing = new System.Windows.Forms.TextBox();
			this.Latitude1 = new System.Windows.Forms.TextBox();
			this.button6 = new System.Windows.Forms.Button();
			this.button5 = new System.Windows.Forms.Button();
			this.label27 = new System.Windows.Forms.Label();
			this.label28 = new System.Windows.Forms.Label();
			this.label26 = new System.Windows.Forms.Label();
			this.label25 = new System.Windows.Forms.Label();
			this.button4 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.BuildNumber = new System.Windows.Forms.Label();
			this.DatabaseDate = new System.Windows.Forms.Label();
			this.InitErrorString = new System.Windows.Forms.Label();
			this.label23 = new System.Windows.Forms.Label();
			this.label24 = new System.Windows.Forms.Label();
			this.label29 = new System.Windows.Forms.Label();
			this.Validation = new System.Windows.Forms.Label();
			this.ExchangeType = new System.Windows.Forms.Label();
			this.PhoneType = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(64, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Build:";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(152, 16);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(96, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Database Date:";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(328, 16);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(88, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Init Error String:";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.PhoneType);
			this.groupBox1.Controls.Add(this.ExchangeType);
			this.groupBox1.Controls.Add(this.Validation);
			this.groupBox1.Controls.Add(this.label29);
			this.groupBox1.Controls.Add(this.label24);
			this.groupBox1.Controls.Add(this.label23);
			this.groupBox1.Controls.Add(this.Results);
			this.groupBox1.Controls.Add(this.label30);
			this.groupBox1.Controls.Add(this.NewAreaCode);
			this.groupBox1.Controls.Add(this.Longitude);
			this.groupBox1.Controls.Add(this.State);
			this.groupBox1.Controls.Add(this.Suffix);
			this.groupBox1.Controls.Add(this.CountyName);
			this.groupBox1.Controls.Add(this.Extension);
			this.groupBox1.Controls.Add(this.PMSA);
			this.groupBox1.Controls.Add(this.TimeZoneCode);
			this.groupBox1.Controls.Add(this.TimeZone);
			this.groupBox1.Controls.Add(this.MSA);
			this.groupBox1.Controls.Add(this.Distance);
			this.groupBox1.Controls.Add(this.CountyFips);
			this.groupBox1.Controls.Add(this.CountryCode);
			this.groupBox1.Controls.Add(this.Prefix);
			this.groupBox1.Controls.Add(this.City);
			this.groupBox1.Controls.Add(this.Latitude);
			this.groupBox1.Controls.Add(this.AreaCode);
			this.groupBox1.Controls.Add(this.PhoneNumber);
			this.groupBox1.Controls.Add(this.button2);
			this.groupBox1.Controls.Add(this.button1);
			this.groupBox1.Controls.Add(this.label22);
			this.groupBox1.Controls.Add(this.label21);
			this.groupBox1.Controls.Add(this.label20);
			this.groupBox1.Controls.Add(this.label19);
			this.groupBox1.Controls.Add(this.label18);
			this.groupBox1.Controls.Add(this.label17);
			this.groupBox1.Controls.Add(this.label16);
			this.groupBox1.Controls.Add(this.label15);
			this.groupBox1.Controls.Add(this.label13);
			this.groupBox1.Controls.Add(this.label12);
			this.groupBox1.Controls.Add(this.label11);
			this.groupBox1.Controls.Add(this.label10);
			this.groupBox1.Controls.Add(this.label9);
			this.groupBox1.Controls.Add(this.label8);
			this.groupBox1.Controls.Add(this.label7);
			this.groupBox1.Controls.Add(this.label6);
			this.groupBox1.Controls.Add(this.ZipCode);
			this.groupBox1.Controls.Add(this.label5);
			this.groupBox1.Controls.Add(this.label4);
			this.groupBox1.Controls.Add(this.label14);
			this.groupBox1.Location = new System.Drawing.Point(16, 40);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(376, 400);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "PhoneCheck Method";
			// 
			// Results
			// 
			this.Results.Location = new System.Drawing.Point(96, 376);
			this.Results.Name = "Results";
			this.Results.Size = new System.Drawing.Size(256, 16);
			this.Results.TabIndex = 45;
			// 
			// label30
			// 
			this.label30.Location = new System.Drawing.Point(16, 376);
			this.label30.Name = "label30";
			this.label30.Size = new System.Drawing.Size(80, 16);
			this.label30.TabIndex = 44;
			this.label30.Text = "Results:";
			// 
			// NewAreaCode
			// 
			this.NewAreaCode.Location = new System.Drawing.Point(288, 160);
			this.NewAreaCode.Name = "NewAreaCode";
			this.NewAreaCode.Size = new System.Drawing.Size(72, 16);
			this.NewAreaCode.TabIndex = 43;
			// 
			// Longitude
			// 
			this.Longitude.Location = new System.Drawing.Point(288, 184);
			this.Longitude.Name = "Longitude";
			this.Longitude.Size = new System.Drawing.Size(72, 16);
			this.Longitude.TabIndex = 42;
			// 
			// State
			// 
			this.State.Location = new System.Drawing.Point(288, 208);
			this.State.Name = "State";
			this.State.Size = new System.Drawing.Size(72, 16);
			this.State.TabIndex = 41;
			// 
			// Suffix
			// 
			this.Suffix.Location = new System.Drawing.Point(288, 232);
			this.Suffix.Name = "Suffix";
			this.Suffix.Size = new System.Drawing.Size(72, 16);
			this.Suffix.TabIndex = 40;
			// 
			// CountyName
			// 
			this.CountyName.Location = new System.Drawing.Point(288, 280);
			this.CountyName.Name = "CountyName";
			this.CountyName.Size = new System.Drawing.Size(72, 16);
			this.CountyName.TabIndex = 39;
			// 
			// Extension
			// 
			this.Extension.Location = new System.Drawing.Point(288, 304);
			this.Extension.Name = "Extension";
			this.Extension.Size = new System.Drawing.Size(72, 16);
			this.Extension.TabIndex = 38;
			// 
			// PMSA
			// 
			this.PMSA.Location = new System.Drawing.Point(288, 328);
			this.PMSA.Name = "PMSA";
			this.PMSA.Size = new System.Drawing.Size(72, 16);
			this.PMSA.TabIndex = 37;
			// 
			// TimeZoneCode
			// 
			this.TimeZoneCode.Location = new System.Drawing.Point(288, 352);
			this.TimeZoneCode.Name = "TimeZoneCode";
			this.TimeZoneCode.Size = new System.Drawing.Size(72, 16);
			this.TimeZoneCode.TabIndex = 36;
			// 
			// TimeZone
			// 
			this.TimeZone.Location = new System.Drawing.Point(96, 352);
			this.TimeZone.Name = "TimeZone";
			this.TimeZone.Size = new System.Drawing.Size(80, 16);
			this.TimeZone.TabIndex = 33;
			// 
			// MSA
			// 
			this.MSA.Location = new System.Drawing.Point(96, 328);
			this.MSA.Name = "MSA";
			this.MSA.Size = new System.Drawing.Size(80, 16);
			this.MSA.TabIndex = 32;
			// 
			// Distance
			// 
			this.Distance.Location = new System.Drawing.Point(96, 304);
			this.Distance.Name = "Distance";
			this.Distance.Size = new System.Drawing.Size(80, 16);
			this.Distance.TabIndex = 31;
			// 
			// CountyFips
			// 
			this.CountyFips.Location = new System.Drawing.Point(96, 280);
			this.CountyFips.Name = "CountyFips";
			this.CountyFips.Size = new System.Drawing.Size(80, 16);
			this.CountyFips.TabIndex = 30;
			// 
			// CountryCode
			// 
			this.CountryCode.Location = new System.Drawing.Point(96, 256);
			this.CountryCode.Name = "CountryCode";
			this.CountryCode.Size = new System.Drawing.Size(80, 16);
			this.CountryCode.TabIndex = 29;
			// 
			// Prefix
			// 
			this.Prefix.Location = new System.Drawing.Point(96, 232);
			this.Prefix.Name = "Prefix";
			this.Prefix.Size = new System.Drawing.Size(80, 16);
			this.Prefix.TabIndex = 28;
			// 
			// City
			// 
			this.City.Location = new System.Drawing.Point(96, 208);
			this.City.Name = "City";
			this.City.Size = new System.Drawing.Size(80, 16);
			this.City.TabIndex = 27;
			// 
			// Latitude
			// 
			this.Latitude.Location = new System.Drawing.Point(96, 184);
			this.Latitude.Name = "Latitude";
			this.Latitude.Size = new System.Drawing.Size(80, 16);
			this.Latitude.TabIndex = 26;
			// 
			// AreaCode
			// 
			this.AreaCode.Location = new System.Drawing.Point(96, 160);
			this.AreaCode.Name = "AreaCode";
			this.AreaCode.Size = new System.Drawing.Size(80, 16);
			this.AreaCode.TabIndex = 25;
			// 
			// PhoneNumber
			// 
			this.PhoneNumber.Location = new System.Drawing.Point(112, 24);
			this.PhoneNumber.Name = "PhoneNumber";
			this.PhoneNumber.Size = new System.Drawing.Size(96, 20);
			this.PhoneNumber.TabIndex = 24;
			this.PhoneNumber.Text = "";
			// 
			// button2
			// 
			this.button2.Location = new System.Drawing.Point(48, 56);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(128, 24);
			this.button2.TabIndex = 23;
			this.button2.Text = "Lookup";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(208, 56);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(128, 24);
			this.button1.TabIndex = 22;
			this.button1.Text = "Correct Area Code";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// label22
			// 
			this.label22.Location = new System.Drawing.Point(200, 352);
			this.label22.Name = "label22";
			this.label22.Size = new System.Drawing.Size(88, 16);
			this.label22.TabIndex = 19;
			this.label22.Text = "TimeZoneCode:";
			// 
			// label21
			// 
			this.label21.Location = new System.Drawing.Point(16, 352);
			this.label21.Name = "label21";
			this.label21.Size = new System.Drawing.Size(80, 16);
			this.label21.TabIndex = 18;
			this.label21.Text = "TimeZone:";
			// 
			// label20
			// 
			this.label20.Location = new System.Drawing.Point(200, 328);
			this.label20.Name = "label20";
			this.label20.Size = new System.Drawing.Size(88, 16);
			this.label20.TabIndex = 17;
			this.label20.Text = "PMSA:";
			// 
			// label19
			// 
			this.label19.Location = new System.Drawing.Point(16, 328);
			this.label19.Name = "label19";
			this.label19.Size = new System.Drawing.Size(80, 16);
			this.label19.TabIndex = 16;
			this.label19.Text = "MSA:";
			// 
			// label18
			// 
			this.label18.Location = new System.Drawing.Point(200, 304);
			this.label18.Name = "label18";
			this.label18.Size = new System.Drawing.Size(88, 16);
			this.label18.TabIndex = 15;
			this.label18.Text = "Extension:";
			// 
			// label17
			// 
			this.label17.Location = new System.Drawing.Point(16, 304);
			this.label17.Name = "label17";
			this.label17.Size = new System.Drawing.Size(80, 16);
			this.label17.TabIndex = 14;
			this.label17.Text = "Distance:";
			// 
			// label16
			// 
			this.label16.Location = new System.Drawing.Point(200, 280);
			this.label16.Name = "label16";
			this.label16.Size = new System.Drawing.Size(88, 16);
			this.label16.TabIndex = 13;
			this.label16.Text = "CountyName:";
			// 
			// label15
			// 
			this.label15.Location = new System.Drawing.Point(16, 280);
			this.label15.Name = "label15";
			this.label15.Size = new System.Drawing.Size(80, 16);
			this.label15.TabIndex = 12;
			this.label15.Text = "CountyFips:";
			// 
			// label13
			// 
			this.label13.Location = new System.Drawing.Point(16, 232);
			this.label13.Name = "label13";
			this.label13.Size = new System.Drawing.Size(80, 16);
			this.label13.TabIndex = 11;
			this.label13.Text = "Prefix:";
			// 
			// label12
			// 
			this.label12.Location = new System.Drawing.Point(200, 232);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(88, 16);
			this.label12.TabIndex = 10;
			this.label12.Text = "Suffix:";
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(200, 208);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(88, 16);
			this.label11.TabIndex = 9;
			this.label11.Text = "State:";
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(16, 208);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(80, 16);
			this.label10.TabIndex = 8;
			this.label10.Text = "City:";
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(200, 184);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(88, 16);
			this.label9.TabIndex = 7;
			this.label9.Text = "Longitude:";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(16, 184);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(80, 16);
			this.label8.TabIndex = 6;
			this.label8.Text = "Latitude:";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(200, 160);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(88, 16);
			this.label7.TabIndex = 5;
			this.label7.Text = "New AreaCode:";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(16, 160);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(80, 16);
			this.label6.TabIndex = 4;
			this.label6.Text = "AreaCode:";
			// 
			// ZipCode
			// 
			this.ZipCode.Location = new System.Drawing.Point(280, 24);
			this.ZipCode.Name = "ZipCode";
			this.ZipCode.Size = new System.Drawing.Size(64, 20);
			this.ZipCode.TabIndex = 3;
			this.ZipCode.Text = "";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(224, 24);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(56, 16);
			this.label5.TabIndex = 2;
			this.label5.Text = "Zip Code";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(32, 24);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(80, 16);
			this.label4.TabIndex = 1;
			this.label4.Text = "Phone Number";
			// 
			// label14
			// 
			this.label14.Location = new System.Drawing.Point(16, 256);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(80, 16);
			this.label14.TabIndex = 5;
			this.label14.Text = "CountryCode:";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.CompDistance);
			this.groupBox2.Controls.Add(this.Longitude2);
			this.groupBox2.Controls.Add(this.Latitude2);
			this.groupBox2.Controls.Add(this.Longitude1);
			this.groupBox2.Controls.Add(this.Bearing);
			this.groupBox2.Controls.Add(this.Latitude1);
			this.groupBox2.Controls.Add(this.button6);
			this.groupBox2.Controls.Add(this.button5);
			this.groupBox2.Controls.Add(this.label27);
			this.groupBox2.Controls.Add(this.label28);
			this.groupBox2.Controls.Add(this.label26);
			this.groupBox2.Controls.Add(this.label25);
			this.groupBox2.Controls.Add(this.button4);
			this.groupBox2.Controls.Add(this.button3);
			this.groupBox2.Location = new System.Drawing.Point(400, 40);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(328, 336);
			this.groupBox2.TabIndex = 4;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Compute Bearing/Distance Method";
			// 
			// CompDistance
			// 
			this.CompDistance.ForeColor = System.Drawing.SystemColors.WindowText;
			this.CompDistance.Location = new System.Drawing.Point(200, 280);
			this.CompDistance.Name = "CompDistance";
			this.CompDistance.Size = new System.Drawing.Size(88, 20);
			this.CompDistance.TabIndex = 36;
			this.CompDistance.Text = "";
			// 
			// Longitude2
			// 
			this.Longitude2.Location = new System.Drawing.Point(232, 160);
			this.Longitude2.Name = "Longitude2";
			this.Longitude2.Size = new System.Drawing.Size(80, 20);
			this.Longitude2.TabIndex = 35;
			this.Longitude2.Text = "";
			// 
			// Latitude2
			// 
			this.Latitude2.Location = new System.Drawing.Point(80, 160);
			this.Latitude2.Name = "Latitude2";
			this.Latitude2.Size = new System.Drawing.Size(80, 20);
			this.Latitude2.TabIndex = 34;
			this.Latitude2.Text = "";
			// 
			// Longitude1
			// 
			this.Longitude1.Location = new System.Drawing.Point(232, 72);
			this.Longitude1.Name = "Longitude1";
			this.Longitude1.Size = new System.Drawing.Size(80, 20);
			this.Longitude1.TabIndex = 33;
			this.Longitude1.Text = "";
			// 
			// Bearing
			// 
			this.Bearing.Location = new System.Drawing.Point(200, 216);
			this.Bearing.Name = "Bearing";
			this.Bearing.Size = new System.Drawing.Size(88, 20);
			this.Bearing.TabIndex = 32;
			this.Bearing.Text = "";
			// 
			// Latitude1
			// 
			this.Latitude1.Location = new System.Drawing.Point(80, 72);
			this.Latitude1.Name = "Latitude1";
			this.Latitude1.Size = new System.Drawing.Size(80, 20);
			this.Latitude1.TabIndex = 31;
			this.Latitude1.Text = "";
			// 
			// button6
			// 
			this.button6.Location = new System.Drawing.Point(40, 280);
			this.button6.Name = "button6";
			this.button6.Size = new System.Drawing.Size(128, 24);
			this.button6.TabIndex = 30;
			this.button6.Text = "Compute Distance";
			this.button6.Click += new System.EventHandler(this.button6_Click);
			// 
			// button5
			// 
			this.button5.Location = new System.Drawing.Point(40, 216);
			this.button5.Name = "button5";
			this.button5.Size = new System.Drawing.Size(128, 24);
			this.button5.TabIndex = 29;
			this.button5.Text = "Compute Bearing";
			this.button5.Click += new System.EventHandler(this.button5_Click);
			// 
			// label27
			// 
			this.label27.Location = new System.Drawing.Point(168, 160);
			this.label27.Name = "label27";
			this.label27.Size = new System.Drawing.Size(64, 16);
			this.label27.TabIndex = 28;
			this.label27.Text = "Longitude 2";
			// 
			// label28
			// 
			this.label28.Location = new System.Drawing.Point(16, 160);
			this.label28.Name = "label28";
			this.label28.Size = new System.Drawing.Size(56, 16);
			this.label28.TabIndex = 27;
			this.label28.Text = "Latitude 2";
			// 
			// label26
			// 
			this.label26.Location = new System.Drawing.Point(168, 72);
			this.label26.Name = "label26";
			this.label26.Size = new System.Drawing.Size(64, 16);
			this.label26.TabIndex = 26;
			this.label26.Text = "Longitude 1";
			// 
			// label25
			// 
			this.label25.Location = new System.Drawing.Point(16, 72);
			this.label25.Name = "label25";
			this.label25.Size = new System.Drawing.Size(56, 16);
			this.label25.TabIndex = 25;
			this.label25.Text = "Latitude 1";
			// 
			// button4
			// 
			this.button4.Location = new System.Drawing.Point(24, 112);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(128, 24);
			this.button4.TabIndex = 24;
			this.button4.Text = "Copy to Coordinate 2";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// button3
			// 
			this.button3.Location = new System.Drawing.Point(24, 32);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(128, 24);
			this.button3.TabIndex = 23;
			this.button3.Text = "Copy to Coordinate 1";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// BuildNumber
			// 
			this.BuildNumber.Location = new System.Drawing.Point(56, 16);
			this.BuildNumber.Name = "BuildNumber";
			this.BuildNumber.Size = new System.Drawing.Size(88, 16);
			this.BuildNumber.TabIndex = 26;
			// 
			// DatabaseDate
			// 
			this.DatabaseDate.Location = new System.Drawing.Point(240, 16);
			this.DatabaseDate.Name = "DatabaseDate";
			this.DatabaseDate.Size = new System.Drawing.Size(72, 16);
			this.DatabaseDate.TabIndex = 27;
			// 
			// InitErrorString
			// 
			this.InitErrorString.Location = new System.Drawing.Point(408, 16);
			this.InitErrorString.Name = "InitErrorString";
			this.InitErrorString.Size = new System.Drawing.Size(304, 16);
			this.InitErrorString.TabIndex = 28;
			// 
			// label23
			// 
			this.label23.Location = new System.Drawing.Point(16, 136);
			this.label23.Name = "label23";
			this.label23.Size = new System.Drawing.Size(88, 16);
			this.label23.TabIndex = 46;
			this.label23.Text = "Phone Type: ";
			// 
			// label24
			// 
			this.label24.Location = new System.Drawing.Point(16, 112);
			this.label24.Name = "label24";
			this.label24.Size = new System.Drawing.Size(88, 16);
			this.label24.TabIndex = 47;
			this.label24.Text = "Exchange Type: ";
			// 
			// label29
			// 
			this.label29.Location = new System.Drawing.Point(16, 88);
			this.label29.Name = "label29";
			this.label29.Size = new System.Drawing.Size(88, 16);
			this.label29.TabIndex = 48;
			this.label29.Text = "Validation: ";
			// 
			// Validation
			// 
			this.Validation.Location = new System.Drawing.Point(112, 88);
			this.Validation.Name = "Validation";
			this.Validation.Size = new System.Drawing.Size(144, 16);
			this.Validation.TabIndex = 49;
			// 
			// ExchangeType
			// 
			this.ExchangeType.Location = new System.Drawing.Point(112, 112);
			this.ExchangeType.Name = "ExchangeType";
			this.ExchangeType.Size = new System.Drawing.Size(144, 16);
			this.ExchangeType.TabIndex = 50;
			// 
			// PhoneType
			// 
			this.PhoneType.Location = new System.Drawing.Point(112, 136);
			this.PhoneType.Name = "PhoneType";
			this.PhoneType.Size = new System.Drawing.Size(136, 16);
			this.PhoneType.TabIndex = 51;
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(744, 446);
			this.Controls.Add(this.InitErrorString);
			this.Controls.Add(this.DatabaseDate);
			this.Controls.Add(this.BuildNumber);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Name = "Form1";
			this.Text = "Melissa Data Phone Object Visual C#.NET Sample";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		#region Initialize Object

    /********************** DATA FILE PATHS **********************
    *    This sample sets the data file path to the installation *
    * default.  If you installed your Melissa Data data files to *
    * a different path, enter that location it below.            *
    * The Data Files Directory must contain the following files: *
    * mdAddr.dat and ZIPNPA.TXT.                                 *
    *************************************************************/
    const string dFILELOC=@"C:\\Program Files\\Melissa DATA\\DQT\\Data";

    /********************** LICENSE STRINGS ************************
    *     To unlock the full functionality of GeoCoder Object,     *
    * please call a sales representative at 1-800-MELISSA ext. 3   *
    *         (1-800-635-4772 x3) for a license string.            *
    *      Without a valid license string, GeoCoder will           *
    *                only code Nevada Zip Codes.                   *
    *             REPLACE "DEMO" with LICENSE STRING               *     
    *                                                              *
    *  SetLicenseString will also check for a valid license in the *
    *  MDPHONE_LICENSE(Environment) variable. This allows you to   *
    *  modify the license without recompiling the project          *
    ***************************************************************/
    const string dLICENSE="DEMO";
        

		public PHONEOBJECTLib.PhoneCheckClass phoneObj;
		
		#endregion
		[STAThread]
		
		static void Main() 
		{
			Application.Run(new Form1());
		}
		private void Form1_Load(object sender, System.EventArgs e)
		{
			phoneObj = new PHONEOBJECTLib.PhoneCheckClass();
			//Set the License String
			phoneObj.SetLicenseString (dLICENSE);
			//Runs at load
			if  (phoneObj.Initialize(dFILELOC) != 0)
			{
				// Initialize failed
				InitErrorString.Text = phoneObj.GetInitializeErrorString();
			}
			else
			{
				//Initialize object
				BuildNumber.Text = phoneObj.GetBuildNumber();
				DatabaseDate.Text = phoneObj.GetDatabaseDate().ToShortDateString();
				InitErrorString.Text = phoneObj.GetInitializeErrorString();
				//Set default data
				ZipCode.Text = "89119";
				PhoneNumber.Text = "7028965154";
			}	
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			String ResultsString;
            //Run Method and Check if valid return
			if (phoneObj.Lookup(PhoneNumber.Text, ZipCode.Text)==1)
			{
				//Field data
				NewAreaCode.Text = "";
				AreaCode.Text = "";
				Latitude.Text = "";
				Longitude.Text = "";
				City.Text = "";
				State.Text = "";
				Prefix.Text = "";
				Suffix.Text = "";
				CountryCode.Text = "";
				CountyFips.Text = "";
				CountyName.Text = "";
				Distance.Text = "";
				Extension.Text = "";
				MSA.Text = "";
				PMSA.Text = "";
				TimeZone.Text = "";
				TimeZoneCode.Text = "";
				Validation.Text = "";
				ExchangeType.Text = "";
				PhoneType.Text = "";
				ResultsString = "";
				AreaCode.Text = phoneObj.AreaCode;
				Latitude.Text = phoneObj.Latitude;
				Longitude.Text = phoneObj.Longitude;
				City.Text = phoneObj.city;
				State.Text = phoneObj.state;
				Prefix.Text = phoneObj.Prefix;
				Suffix.Text = phoneObj.Suffix;
				CountryCode.Text = phoneObj.CountryCode;
				CountyFips.Text = phoneObj.CountyFips;
				CountyName.Text = phoneObj.CountyName;
				Distance.Text = phoneObj.Distance;
				Extension.Text = phoneObj.Extension;
				MSA.Text = phoneObj.Msa;
				PMSA.Text = phoneObj.Pmsa;
				TimeZone.Text = phoneObj.TimeZone;
				TimeZoneCode.Text = phoneObj.TimeZoneCode;
				Results.Text = phoneObj.Results;
				ResultsString = phoneObj.Results;
				if ((ResultsString.IndexOf("PS01")!= -1) || (ResultsString.IndexOf("PS02")!= -1))
				{
					if (ResultsString.IndexOf("PS01")!= -1)
						Validation.Text = "Validated to 10 Digits";
					else if (ResultsString.IndexOf("PS02")!= -1)
						Validation.Text = "Validated to 7 Digits";

					if (ResultsString.IndexOf("PS07")!= -1)
						ExchangeType.Text = "Cellular";
					else if (ResultsString.IndexOf("PS08")!= -1)
						ExchangeType.Text = "Land Line";
					else if (ResultsString.IndexOf("PS09")!= -1)
						ExchangeType.Text = "Voip";

					if (ResultsString.IndexOf("PS10")!= -1)
						PhoneType.Text = "Residential";
					else if (ResultsString.IndexOf("PS11")!= -1)
						PhoneType.Text = "Business";
					else if (ResultsString.IndexOf("PS12")!= -1)
						PhoneType.Text = "Small/Home Office";
				}
			}
			else
			{
				NewAreaCode.Text = "";
				AreaCode.Text = "";
				Latitude.Text = "";
				Longitude.Text = "";
				City.Text = "";
				State.Text = "";
				Prefix.Text = "";
				Suffix.Text = "";
				CountryCode.Text = "";
				CountyFips.Text = "";
				CountyName.Text = "";
				Distance.Text = "";
				Extension.Text = "";
				MSA.Text = "";
				PMSA.Text = "";
				TimeZone.Text = "";
				TimeZoneCode.Text = "";
				Validation.Text = "";
				ExchangeType.Text = "";
				PhoneType.Text = "";
				ResultsString = "";
				Results.Text = phoneObj.Results;
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
        //Clear data
        Latitude.Text = "";
        Longitude.Text = "";
        City.Text = "";
        State.Text = "";
        Prefix.Text = "";
        Suffix.Text = "";
        CountryCode.Text = "";
        CountyFips.Text = "";
        CountyName.Text = "";
        Distance.Text = "";
        Extension.Text = "";
        MSA.Text = "";
        PMSA.Text = "";
        TimeZone.Text = "";
        TimeZoneCode.Text = "";
        Results.Text = "";

        //Run Method and Check if valid return
			if( phoneObj.CorrectAreaCode(PhoneNumber.Text, ZipCode.Text)==1)
			{
				//Field Data
				NewAreaCode.Text = phoneObj.NewAreaCode;
				AreaCode.Text = phoneObj.AreaCode;
				Results.Text = phoneObj.Results;
			}
        		
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			//Store Coordinates
			Longitude1.Text=phoneObj.Longitude;
			Latitude1.Text=phoneObj.Latitude;
		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			//Store Coordinates
			Longitude2.Text=phoneObj.Longitude;
			Latitude2.Text=phoneObj.Latitude;
		}

		private void button5_Click(object sender, System.EventArgs e)
		{
			//Calculate bearing using stored coordinates
			Bearing.Text=phoneObj.ComputeBearing(Latitude1.Text,Longitude1.Text,Latitude2.Text,Longitude2.Text).ToString();
	
		}

		private void button6_Click(object sender, System.EventArgs e)
		{
			//Calculate distance using stored coordinates
			CompDistance.Text=phoneObj.ComputeDistance(Latitude1.Text,Longitude1.Text,Latitude2.Text,Longitude2.Text).ToString();
		}
		

	}
}
